//package num;
import java.util.*;
interface ComputeData{
		// ݭnXӰѼƨӭp.
	final static int NONE=0;
	final static int UNARY_OPERATOR=1;
	final static int BINARY_OPERATOR=2;
		// puǡCƭȶVjAhuǶV.
	final static int LEVAL_UP=100;// VW[@j.
	final static int LEVAL_DOWN=-LEVAL_UP;// VU@j.
	final static int LEVAL1=40;// A.
	final static int LEVAL2=35;// ܼ x,pi
	final static int LEVAL3=30;// 
	final static int LEVAL4=25;// Od.
	final static int LEVAL5=20;// @WVơA^Bt.
	final static int LEVAL6=15;// *,/
	final static int LEVAL7=10;// +,-
	final static int LEVAL8=5;// ̧C.

	final static int ACOS=0;
	final static int ADD=1;
	final static int ANS=2;
	final static int ASIN=3;
	final static int ATAN=4;
	final static int COS=5;
	final static int DIV=6;
	final static int EXP=7;
	final static int LN=8;
	final static int LOG=9;
	final static int MOD=10;
	final static int MUL=11;
	final static int NEG=12;
	final static int POW=13;
	final static int PI=14;
	final static int SIN=15;
	final static int SQRT=16;
	final static int SUB=17;
	final static int TAN=18;
	final static int X=19;
	final static int SIZE=20;
}//end of class	ComputeData
//C@ӹBŸ򥻸.
class EvaluateData{
	String name;//BŸW.
	int priority;//Bu.
	int operator;//ݭnXӹB.
	int id;//bBŸAOĴX.
	EvaluateData(String name,int priority,int operator,int id){
		this.name=name;
		this.priority=priority;
		this.operator=operator;
		this.id=id;
	}
}//end of class	EvaluateData
public class Evaluate implements ComputeData{
	private Hashtable hash;//sB.
	private String postfix=null;//ǦG.
	private String expression="0";//B⦡r.
	private String errorMessage="No error !";//wS~.
	private boolean	isDegree=false;//wϥy.
	private double x=0.0d;//x ܼơAwȬ 0
	private double lastAnswer=0d;//s̫ᵲG.
	public EvaluateData[] functionTable;//sBŸ.
	public Evaluate(){
		int i=0;
		functionTable=new EvaluateData[SIZE];
		functionTable[i++]=new EvaluateData("sin",LEVAL5,UNARY_OPERATOR,SIN);
		functionTable[i++]=new EvaluateData("cos",LEVAL5,UNARY_OPERATOR,COS);
		functionTable[i++]=new EvaluateData("tan",LEVAL5,UNARY_OPERATOR,TAN);
		functionTable[i++]=new EvaluateData("exp",LEVAL5,UNARY_OPERATOR,EXP);
		functionTable[i++]=new EvaluateData("asin",LEVAL5,UNARY_OPERATOR,ASIN);
		functionTable[i++]=new EvaluateData("acos",LEVAL5,UNARY_OPERATOR,ACOS);
		functionTable[i++]=new EvaluateData("atan",LEVAL5,UNARY_OPERATOR,ATAN);
		functionTable[i++]=new EvaluateData("ln",LEVAL5,UNARY_OPERATOR,LN);
		functionTable[i++]=new EvaluateData("sqrt",LEVAL5,UNARY_OPERATOR,SQRT);
		functionTable[i++]=new EvaluateData("^",LEVAL5,BINARY_OPERATOR,POW);
		functionTable[i++]=new EvaluateData("pi",LEVAL2,NONE,PI);
		functionTable[i++]=new EvaluateData("log",LEVAL5,UNARY_OPERATOR,LOG);
		functionTable[i++]=new EvaluateData("x",LEVAL2,NONE,X);
		functionTable[i++]=new EvaluateData("ans",LEVAL2,NONE,ANS);
		functionTable[i++]=new EvaluateData("mod",LEVAL5,BINARY_OPERATOR,MOD);
		functionTable[i++]=new EvaluateData("neg",LEVAL5,UNARY_OPERATOR,NEG);
		functionTable[i++]=new EvaluateData("+",LEVAL7,BINARY_OPERATOR,ADD);
		functionTable[i++]=new EvaluateData("-",LEVAL7,BINARY_OPERATOR,SUB);
		functionTable[i++]=new EvaluateData("/",LEVAL6,BINARY_OPERATOR,DIV);
		functionTable[i++]=new EvaluateData("*",LEVAL6,BINARY_OPERATOR,MUL);

		hash=new Hashtable(30);
		for(i=0;i<SIZE;i++)
			hash.put(functionTable[i].name,functionTable[i]);
	}
	public Evaluate(String expression){
		this();
		setExpression(expression);
	}
	//]wDȤB⦡.
	public void setExpression(String expression){
		this.expression=expression.toLowerCase();
		analysis();
	}
	//oB~T.
	public String getError(){
		return errorMessage;
	}
	//oyǦBzr.
	public String getPostfix(){
		if(postfix==null)
			analysis();
		return postfix;
	}
	//]w x ܼ.
	public void setX(double x){
		this.x=x;
	}
	//o x ܼ.
	public double getX(){
		return x;
	}
	//]wTơAϥy׶qΨ׶q.
	public void setDegreeState(boolean isDegree){
		this.isDegree=isDegree;
	}
	final static int IS_NUMBER=1;// wq`ơANƦr.
	final static int IS_LETTER=2;// wq`ơANr.
	final static int IS_LEFT=4;// wq`ơANA.
	final static int IS_RIGHT=8;// wq`ơANkA.
	final static int IS_SPACE=16;// wq`ơANť.
	final static int IS_OTHERS=32;// wq`ơANL.
		// Nr.
	private int classify(char ch){
		if(Character.isLetter(ch))
			return IS_LETTER;
		else if(Character.isDigit(ch) || ch=='.')
			return IS_NUMBER;
		else if(Character.isWhitespace(ch))
			return IS_SPACE;
		else if(ch=='(')
			return IS_LEFT;
		else if(ch==')')
			return IS_RIGHT;
		else
			return IS_OTHERS;
	}//end of classify
	//yk~.
	private void SyntaxError(String str){
		errorMessage="Syntax error"+((str==null)?" !":(" : "+str+" !"));
		throw new NumberFormatException(errorMessage);
	}
	//k~.
	private void MethodError(String str){
		errorMessage=str+" is not define !";
		throw new NoSuchMethodError(errorMessage);// So禡.
	}
	//]w x ܼơAAoB⵲G.
	public double getValue(double x){
		this.x=x;
		return this.getValue();
	}
		// ѡyǹB⦡zDop⵲G.
	public double getValue(){
		int i;
		double v1=0d,v2;
		Stack numStack=new Stack();
		EvaluateData op=null;
		Double[] value=new Double[2];
		for(i=0;i<2;i++)
			value[i]=new Double(0d);
		StringTokenizer st=new StringTokenizer(postfix);
		//qyǹB⦡zrꤤA@ӭӨXARùB.
		while(st.hasMoreTokens()){
			String token=st.nextToken();
			if(classify(token.charAt(0))==IS_NUMBER){
				numStack.push(new Double(token));
				op=null;
			}
			else{
				op=(EvaluateData)hash.get(token);
			}//end of if
			if(op!=null && op.operator>numStack.size())//new
				SyntaxError(token);
			if(op!=null){
				for(i=0;i<op.operator;i++)
					value[i]=(Double)numStack.pop();
				//̷ӦUƨӧ@B.
				switch(op.id){
					case SIN :
						v1=value[0].doubleValue();
						if(isDegree)
							v1=v1*Math.PI/180;
						v1=Math.sin(v1);
						break;
					case COS :
						v1=value[0].doubleValue();
						if(isDegree)
							v1=v1*Math.PI/180;
						v1=Math.cos(v1);
						break;
					case TAN :
						v1=value[0].doubleValue();
						if(isDegree)
							v1=v1*Math.PI/180;
						v1=Math.tan(v1);
						break;
					case ASIN :
						v1=value[0].doubleValue();
						v1=Math.asin(v1);
						if(isDegree)
							v1=v1*180/Math.PI;
						break;
					case ACOS :
						v1=value[0].doubleValue();
						v1=Math.acos(v1);
						if(isDegree)
							v1=v1*180/Math.PI;
						break;
					case ATAN :
						v1=value[0].doubleValue();
						v1=Math.atan(v1);
						if(isDegree)
							v1=v1*180/Math.PI;
						break;
					case EXP :
						v1=value[0].doubleValue();
						v1=Math.exp(v1);
						break;
					case LN :
						v1=value[0].doubleValue();
						v1=Math.log(v1);
						break;
					case SQRT :
						v1=value[0].doubleValue();
						v1=Math.sqrt(v1);
						break;
					case POW :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=Math.pow(v2,v1);
						break;
					case PI :
						v1=Math.PI;
						break;
					case X :
						v1=x;
						break;
					case ADD :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=v1+v2;
						break;
					case SUB :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=v2-v1;
						break;
					case MUL :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=v2*v1;
						break;
					case DIV :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=v2/v1;
						break;
					case LOG :
						v1=value[0].doubleValue();
						v1=Math.log(v1)/Math.log(10);
						break;
					case ANS :
						v1=lastAnswer;
						break;
					case MOD :
						v1=value[0].doubleValue();
						v2=value[1].doubleValue();
						v1=Math.IEEEremainder(v2,v1);
						break;
					case NEG :
						v1=-value[0].doubleValue();
						break;
				}//end of switch
				numStack.push(new Double(v1));
			}//end if(op.operator<=numStack.size())
		}//end of while(st.hasMoreTokens()
		if(numStack.size()==1)
			v1=((Double)numStack.pop()).doubleValue();
		else
			SyntaxError(null);// ~.
		lastAnswer=v1;
		return v1;
	}//end of getValue()

	//[J@ӹBŸ|.
	private void toPostfix(Stack opStack,StringBuffer sbuffer,String op,int priority){
		double v1,v2;
		EvaluateData data;
		int operator=0;
		if(op != null)
			operator = ((EvaluateData)hash.get(op)).operator;
		//pGs[JBŸuǤ|p,
		//hN|ABuǸ̿X sbuffer.
		while(!opStack.empty()){
			data=(EvaluateData)opStack.peek();
			//GBGۦPBuǥѥܥk.
			// p 3 - 2 - 3
			if(operator == BINARY_OPERATOR){
				if(priority <= data.priority){
					data=(EvaluateData)opStack.pop();
					sbuffer.append(data.name+' ');
				}
				else
					break;
			}
			//@BGۦPBuǥѥkܥ.
			//p sin cos x
			else{
				if(priority < data.priority){
					data=(EvaluateData)opStack.pop();
					sbuffer.append(data.name+' ');
				}
				else
					break;
			}
		}//end of while
		//̫ANs[JBŸAJ|.
		if(op!=null){
			data=(EvaluateData)hash.get(op);
			opStack.push(new EvaluateData(data.name,priority,data.operator,data.id));
		}
	}//end of toPostfix

	final static int REAL_NUMBER=1;
	final static int RETURN_NUMBER=2;
	final static int NOT_NUMBER=4;
	// RǹB⦡ ==> ǹB⦡.
	// ƦrX sbuffer ABŸhJ|.
	public void analysis(){
		int StringIndex;//prRF.
		int temp;//Ȯɩܼ.
		int precede=NOT_NUMBER;//e@ӹBŸOԣ ?
		int thisLeval=0;//ثeBuǭȬOh.
		int saveLastPriority=LEVAL8;//̤pBu.
		char ch;
		Stack opStack=new Stack();
		String token;//CŪX@ token
		StringBuffer sbuffer=new StringBuffer();//sBXa.
		EvaluateData op,opMul=(EvaluateData)hash.get("*");//]ḵ`.
		for(StringIndex=0;StringIndex<expression.length();){
			ch=expression.charAt(StringIndex);
			switch(classify(ch)){
				//pGOťաAhL.
			case IS_SPACE :
				temp=skipSpace(expression,StringIndex);
				StringIndex=temp;
				break;
				//pGOr.
			case IS_LETTER :
				temp=findLetter(expression,StringIndex);
				token=expression.substring(StringIndex,temp);
				op=(EvaluateData)hash.get(token);
				if(op==null)
					MethodError(token);
				if(precede!=NOT_NUMBER){// pGW@ӶǦ^OƦrAάOƦrh.
					if(op.operator==UNARY_OPERATOR || op.operator==NONE){
						if(precede==REAL_NUMBER && op.operator==NONE)
							toPostfix(opStack,sbuffer,opMul.name,LEVAL5+thisLeval);
						else
							toPostfix(opStack,sbuffer,opMul.name,opMul.priority+thisLeval);
					}
				}
				else if(op.operator==BINARY_OPERATOR)// pGBe@ӤOƦr.
					SyntaxError(op.name);
				toPostfix(opStack,sbuffer,op.name,op.priority+thisLeval);
				StringIndex=temp;
				if(op.operator==NONE){
					precede=RETURN_NUMBER;
				}
				else{
					precede=NOT_NUMBER;
				}
				break;
				//pGOƦrAhX.
			case IS_NUMBER :
				temp=findNumber(expression,StringIndex);
				sbuffer.append(expression.substring(StringIndex,temp)+' ');
				StringIndex=temp;
				precede=REAL_NUMBER;
				break;
				//pGOL]rBŸ^.
			case IS_OTHERS :
				temp=findOperator(expression,StringIndex);
				token=expression.substring(StringIndex,temp);
				op=(EvaluateData)hash.get(token);
				if(op==null)
					MethodError(token);
				//pGe@ token OƦrιBOƦr.
				if(precede==RETURN_NUMBER || precede==REAL_NUMBER){
					toPostfix(opStack,sbuffer,op.name,op.priority+thisLeval);
				}
				else{
					if("+".equals(op.name)){
						// 
					}
					else if("-".equals(op.name)){
						int i=skipSpace(expression,temp);
						op=(EvaluateData)hash.get("neg");
						toPostfix(opStack,sbuffer,op.name,op.priority+thisLeval);
					}
					else
						SyntaxError(op.name);
				}
				StringIndex=temp;
				precede=NOT_NUMBER;
				break;
				//pGOA.
			case IS_LEFT :
				if(precede==RETURN_NUMBER || precede==REAL_NUMBER){
					toPostfix(opStack,sbuffer,opMul.name,opMul.priority+thisLeval);
				}
				if(!opStack.empty())
					saveLastPriority=((EvaluateData)opStack.peek()).priority;
				else
					saveLastPriority=LEVAL8;
				thisLeval+=LEVAL1;
				precede=NOT_NUMBER;
				StringIndex++;
				break;
				//pGOkA.
			case IS_RIGHT :
				thisLeval-=LEVAL1;
				if(thisLeval<0)
					SyntaxError(")");
				precede=RETURN_NUMBER;
				toPostfix(opStack,sbuffer,null,saveLastPriority);
				StringIndex++;
				break;
			}
		}
		//N|BŸAX.
		toPostfix(opStack,sbuffer,null,LEVAL8);
		if(opStack.size()!=0)
			SyntaxError(null);
		else
			errorMessage="No error !";
		postfix=sbuffer.toString();
	}//end of analysis()
	// str A start Ӧr_,
	//@줣OƦrA䴩ƪܪk.
	private int findNumber(String str,int start){
		int i;
		boolean error=false;
		char ch=str.charAt(start);
		for(i=start;i<str.length();i++){
			ch=str.charAt(i);
			if(!Character.isDigit(ch))
				break;//OƦrAhXj.
		}//end of for
		if(ch=='.')
			for(i++;i<str.length();i++){
				ch=str.charAt(i);
				if(!Character.isDigit(ch))
					break;//OƦrAhXj.
			}//end of for
		if(ch=='e'){
			ch=str.charAt(++i);
			if(ch!='+' && ch!='-' && !Character.isDigit(ch)){
				error=true;
			}
			else
				for(i++;i<str.length();i++){
					ch=str.charAt(i);
					if(!Character.isDigit(ch))
						break;//OƦrAhXj.
				}//end of for
		}
		if(error)
			SyntaxError(str.substring(start,i));
		return i;
	}//end of findNumber
	// str A start Ӧr_,
	//@줣O^r.
	private int findLetter(String str,int start){
		int i;
		char ch;
		for(i=start;i<str.length();i++){
			ch=str.charAt(i);
			if(Character.isLetter(ch))
				continue;
			else
				break;
		}
		return i;
	}//end of findLetter
	// str A start Ӧr_,
	//@줣Oťլ.
	private int skipSpace(String str,int start){
		int i;
		char ch;
		for(i=start;i<str.length();i++){
			ch=str.charAt(i);
			if(Character.isWhitespace(ch))
				continue;
			else
				break;
		}
		return i;
	}//end of skipSpace
	// str A start Ӧr_,
	//M@ӦrBŸAp + - * / ^ ( ) K.
	private int findOperator(String	str,int	start){
		int i=start;
		char ch=str.charAt(i);
		if(hash.containsKey(String.valueOf(ch)))
			return i+1;
		else//error
			return i+1;
	}//end of findOperator
}//end of class	Evaluate
